/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import twilightforest.block.ConnectableRotatedPillarBlock;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFDamageTypes;

public class ThornsBlock
extends ConnectableRotatedPillarBlock
implements SimpleWaterloggedBlock {
    protected static final VoxelShape BASE_SHAPE = Block.m_49796_((double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0);
    protected static final VoxelShape WEST_SHAPE = Block.m_49796_((double)0.0, (double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)13.0);
    protected static final VoxelShape EAST_SHAPE = Block.m_49796_((double)13.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0);
    protected static final VoxelShape DOWN_SHAPE = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)3.0, (double)13.0);
    protected static final VoxelShape UP_SHAPE = Block.m_49796_((double)3.0, (double)13.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    protected static final VoxelShape NORTH_SHAPE = Block.m_49796_((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)3.0);
    protected static final VoxelShape SOUTH_SHAPE = Block.m_49796_((double)3.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0, (double)16.0);
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final float THORN_DAMAGE = 4.0f;

    public ThornsBlock(BlockBehaviour.Properties props) {
        super(props, 10.0);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_55923_, (Comparable)Direction.Axis.Y)).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public boolean canConnectTo(Direction.Axis thisAxis, Direction facing, BlockState facingState, boolean solidSide) {
        return facingState.m_60734_() instanceof ThornsBlock || facingState.m_60734_().equals(TFBlocks.THORN_ROSE.get()) || facingState.m_60734_().equals(TFBlocks.THORN_LEAVES.get()) || facingState.m_60734_().equals(TFBlocks.WEATHERED_DEADROCK.get());
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        VoxelShape shape = BASE_SHAPE;
        if (((Boolean)state.m_61143_((Property)DOWN)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)DOWN_SHAPE);
        }
        if (((Boolean)state.m_61143_((Property)UP)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)UP_SHAPE);
        }
        if (((Boolean)state.m_61143_((Property)NORTH)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)NORTH_SHAPE);
        }
        if (((Boolean)state.m_61143_((Property)SOUTH)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)SOUTH_SHAPE);
        }
        if (((Boolean)state.m_61143_((Property)WEST)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)WEST_SHAPE);
        }
        if (((Boolean)state.m_61143_((Property)EAST)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)EAST_SHAPE);
        }
        return shape;
    }

    @Nullable
    public BlockPathTypes getBlockPathType(BlockState state, BlockGetter getter, BlockPos pos, @Nullable Mob entity) {
        return BlockPathTypes.DAMAGE_OTHER;
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        entity.m_6469_(TFDamageTypes.getDamageSource(level, TFDamageTypes.THORNS, new EntityType[0]), 4.0f);
    }

    public void m_141947_(Level level, BlockPos pos, BlockState state, Entity entity) {
        if (state.m_60734_() instanceof ThornsBlock && state.m_61143_((Property)f_55923_) == Direction.Axis.Y) {
            this.m_7892_(state, level, pos, entity);
        }
        super.m_141947_(level, pos, state, entity);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (!player.m_150110_().f_35937_) {
            if (!level.m_5776_()) {
                this.doThornBurst(level, pos, state);
            }
            return false;
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    private void doThornBurst(Level level, BlockPos pos, BlockState state) {
        switch ((Direction.Axis)state.m_61143_((Property)f_55923_)) {
            case Y: {
                this.growThorns(level, pos, Direction.UP);
                this.growThorns(level, pos, Direction.DOWN);
                break;
            }
            case X: {
                this.growThorns(level, pos, Direction.EAST);
                this.growThorns(level, pos, Direction.WEST);
                break;
            }
            case Z: {
                this.growThorns(level, pos, Direction.NORTH);
                this.growThorns(level, pos, Direction.SOUTH);
            }
        }
        this.growThorns(level, pos, Direction.m_235672_((RandomSource)level.m_213780_()));
        this.growThorns(level, pos, Direction.m_235672_((RandomSource)level.m_213780_()));
        this.growThorns(level, pos, Direction.m_235672_((RandomSource)level.m_213780_()));
    }

    private void growThorns(Level level, BlockPos pos, Direction dir) {
        BlockPos dPos;
        int length = 1 + level.m_213780_().m_188503_(3);
        for (int i = 1; i < length && level.m_46859_(dPos = pos.m_5484_(dir, i)); ++i) {
            level.m_7731_(dPos, (BlockState)((Block)TFBlocks.GREEN_THORNS.get()).m_49966_().m_61124_((Property)f_55923_, (Comparable)dir.m_122434_()), 2);
        }
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction.Axis axis = context.m_43719_().m_122434_();
        BlockState state = (BlockState)this.m_49966_().m_61124_((Property)f_55923_, (Comparable)context.m_43719_().m_122434_());
        BlockPos pos = context.m_8083_();
        for (Direction direction : Direction.values()) {
            BlockPos relativePos = pos.m_121945_(direction);
            BlockState relativeState = context.m_43725_().m_8055_(relativePos);
            state = (BlockState)state.m_61124_((Property)PipeBlock.f_55154_.get(direction), (Comparable)Boolean.valueOf(this.canConnectTo(axis, direction, relativeState, true)));
        }
        return (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_));
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor accessor, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            accessor.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)accessor));
        }
        if (facingState.m_60713_(Blocks.f_50016_)) {
            return state;
        }
        return super.m_7417_(state, facing, facingState, accessor, currentPos, facingPos);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{WATERLOGGED});
    }
}

